# Organization Access Policy

## Purpose
Restrict Google authentication and service access to users within a specific Google Workspace organization to prevent cross-organization data leakage and ensure compliance.

## Configuration
Set `ALLOWED_ORGANIZATION` in `.env` to your Google Workspace domain (e.g. `example.com`). Leave empty to allow any domain.

## Enforcement Points
1. **Google ID Token Verification** (`src/auth.js`)
   - Checks `payload.hd` (hosted domain) against `ALLOWED_ORGANIZATION`
   - Rejects sign-in with detailed logging if domain mismatch

2. **OAuth Callback** (`src/oauth.js`)
   - Re-verifies user email domain before storing tokens
   - Prevents token issuance to out-of-org users who bypassed initial check

## Error Handling
- Returns `organization_access_denied` error code to frontend
- Logs: timestamp, email, attempted domain, allowed domain
- Does not reveal internal configuration details to end user

## Cross-Organization Access
Not supported by design. If required, implement:
- Explicit admin whitelist of external domains
- Separate service account delegation model
- Audit trail for external access grants

## Monitoring
Review logs for patterns:
- Repeated domain mismatches (potential probing)
- Token refresh failures post-domain change
- Unusual geographic or device patterns

## Compliance
Align with company data residency and access policies. Review annually or on policy change.